<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Zone extends Model 
{

    protected $table = 'zones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function arays()
    {
        return $this->hasMany('Aray');
    }

    public function shelters()
    {
        return $this->hasMany('Shelter');
    }

    public function site()
    {
        return $this->belongsTo('Site');
    }

}